/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util.types;

import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public enum Stone {
    STONE(true, false),
    ANDESITE(true, true),
    GRANITE(true, true),
    DIORITE(true, true),
    SANDSTONE(true, false),
    RED_SANDSTONE(true, false),
    MARBLE(false, true),
    LIMESTONE(false, true),
    BASALT(false, true),
    SLATE(false, true);

    private final boolean isDefault;
    private final boolean hasCobblestone;

    @Nonnull
    public static Stone getFromBlock(IBlockState state, Random random) {
        Stone stone = Stone.getFromBlock(state);
        if (stone == STONE && ModConfig.GENERAL.enableRandomStoneWorldGenVariants) {
            switch (random.nextInt(5)) {
                case 0: {
                    return GRANITE;
                }
                case 1: {
                    return ANDESITE;
                }
                case 2: {
                    return DIORITE;
                }
            }
        }
        return stone == null ? STONE : stone;
    }

    @Nullable
    public static Stone getFromBlock(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150348_b) {
            switch ((BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a)) {
                case STONE: {
                    return STONE;
                }
                case DIORITE: {
                    return DIORITE;
                }
                case GRANITE: {
                    return GRANITE;
                }
                case ANDESITE: {
                    return ANDESITE;
                }
            }
        }
        if (state.func_177230_c() == Blocks.field_150322_A) {
            return SANDSTONE;
        }
        if (state.func_177230_c() == Blocks.field_180395_cM) {
            return RED_SANDSTONE;
        }
        String registryName = state.func_177230_c().getRegistryName().toString();
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == 0) {
            switch (registryName) {
                case "quark:limestone": 
                case "chisel:limestone": {
                    return LIMESTONE;
                }
                case "quark:marble": 
                case "chisel:marble": {
                    return MARBLE;
                }
                case "quark:basalt": 
                case "chisel:basalt": {
                    return BASALT;
                }
                case "rustic:slate": {
                    return SLATE;
                }
            }
        }
        return null;
    }

    private Stone(boolean isDefault, boolean hasCobblestone) {
        this.isDefault = isDefault;
        this.hasCobblestone = hasCobblestone;
    }

    private static ItemStack getStackByRegistryName(String ... names) {
        for (String name : names) {
            ItemStack stack = CoreHelpers.getStackByRegistryName((String)name, (int)1, (int)0);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getStoneStack() {
        switch (this) {
            case STONE: {
                return new ItemStack(Blocks.field_150348_b);
            }
            case SANDSTONE: {
                return new ItemStack(Blocks.field_150322_A);
            }
            case DIORITE: {
                return new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.DIORITE.func_176642_a());
            }
            case GRANITE: {
                return new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.GRANITE.func_176642_a());
            }
            case ANDESITE: {
                return new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.ANDESITE.func_176642_a());
            }
            case SLATE: {
                return CoreHelpers.getStackByRegistryName((String)"rustic:slate", (int)1, (int)0);
            }
            case MARBLE: {
                return Stone.getStackByRegistryName("quark:marble", "chisel:marble");
            }
            case LIMESTONE: {
                return Stone.getStackByRegistryName("quark:limestone", "chisel:limestone");
            }
            case BASALT: {
                return Stone.getStackByRegistryName("quark:basalt", "chisel:basalt");
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean hasCobblestone() {
        return this.hasCobblestone;
    }

    public boolean isEnabled() {
        if (this.isDefault()) {
            return true;
        }
        switch (this) {
            case MARBLE: 
            case LIMESTONE: 
            case BASALT: {
                return Loader.isModLoaded((String)"quark") && ModConfig.COMPAT.enableQuarkCompat || Loader.isModLoaded((String)"chisel") && ModConfig.COMPAT.enableChiselCompat;
            }
            case SLATE: {
                return Loader.isModLoaded((String)"rustic") && ModConfig.COMPAT.enableRusticCompat;
            }
        }
        return false;
    }
}

